// This script opens an image sequence in Quicktime and exports it to a Quicktime Movie -- showing the export dialog
// to run from the command line :
// cscript qtSeq2mov.js <imgsSourcePath> <soundSourcePath>(opt.)
//
// if only one argument is set, the movie will have no sound.
//
// IMPROVEMENTS:
// - after user defines export settings for the first time, save them in a file, and
// automatically use those settings in future uses of the script.
// This is mostly implemented - commented lines - but "qtExporter.Settings.XML" does not work

// FrameRate
var frate = 25;

// Get script argument
var soundPath
if (WScript.Arguments.Length == 1)  {
    sourcePath = WScript.Arguments(0);
} else if (WScript.Arguments.Length > 1) {
	sourcePath = WScript.Arguments(0);
	soundPath = WScript.Arguments(1);
}   else    {
    WScript.Echo("not enough parameters");
    WScript.Quit();
}

// Launch QuickTime Player Application
var qtPlayerApp = WScript.CreateObject("QuickTimePlayerLib.QuickTimePlayerApp");
WScript.Sleep(1000)
if (qtPlayerApp == null)    {
    WScript.Echo("Unable to launch QuickTime Player!");
    WScript.Quit();
}

// Get the QuickTime controller
var qtPlayerSrc = qtPlayerApp.Players(1);
if (qtPlayerSrc == null)
    WScript.Quit();
var qtControl =  qtPlayerSrc.QTControl;

// Set up the exporter and have it configured
var qt = qtPlayerSrc.QTControl.QuickTime;
qt.Exporters.Add();
var qtExporter = qt.Exporters(1);

/*
var CodecInfoFileName = "C:\\QuickTimeCodecInfo.xml";

var FileSystemObject =  WScript.CreateObject("Scripting.FileSystemObject");
var CodecFileInfo;

if ( FileSystemObject.FileExists(CodecInfoFileName) )
    CodecFileInfo =  FileSystemObject.OpenTextFile( CodecInfoFileName );
*/
// Open image sequence in quicktime
qtControl.CreateNewMovieFromImages( sourcePath, 
                                    frate,     // frame rate
                                    true ); // rate is in frames per seconds 
var qtMovie = qtControl.Movie;

qtExporter.TypeName = "QuickTime Movie";
qtExporter.SetDataSource( qtMovie );

// if sound source was specified, load it
if (soundPath) {
	qtPlayerApp.Players.Add();
	var qtPlayerSrc2 = qtPlayerApp.Players(2);
	var qtControl2 =  qtPlayerSrc2.QTControl;
	qtControl2.URL = soundPath;
	// copy/paste sound to movie
	qtControl2.Movie.SelectAll();
	qtControl2.Movie.Copy();
	qtControl.Movie.Add();
}

/*
if ( CodecFileInfo )    {
    var xmlCodecInfoText = CodecFileInfo.ReadAll();
    // cause the exporter to be reconfigured 
    // http://developer.apple.com/technotes/tn2006/tn2120.html
    var tempSettings = qtExporter.Settings;
    tempSettings.XML = xmlCodecInfoText;
    qtExporter.Settings = tempSettings;

} else  {
*/

// do the actual export
qtExporter.ShowExportDialog();

/*    CodecFileInfo = FileSystemObject.CreateTextFile( CodecInfoFileName );
    if ( CodecFileInfo )  {
        CodecFileInfo.WriteLine(qtExporter.Settings.XML);
        CodecFileInfo.Close();

    }
}
*/

qtExporter.ShowProgressDialog = true;
qtExporter.BeginExport();
qtPlayerSrc.Close();
if (qtPlayerSrc2)
	qtPlayerSrc2.Close();