/*
	TODO:
	- Add option to display/hide viewport elements (title, axis tripod, etc.)
	- Open Quicktime preview file after creation.
*/

macroScript movPreviewMaker
category:"MayecTools"
buttontext:".mov Preview"
tooltip:".mov Preview Maker"
Icon:#("Mayec",1)

(

	if renderPixelAspect > 1 then (
		global finalWidth = renderWidth * renderPixelAspect
		global finalHeight = renderHeight
	)
	else (
		global finalWidth = renderWidth
		global finalHeight = renderHeight / renderPixelAspect
	)
	version = "b2"

	fn existDir dname = (getDirectories dname).count != 0
	
	fn mkPreviewSeq previewDir fileName sizex sizey startFrame endFrame =
	(
		view_size = getViewSize()
		cropH = (view_size.x-sizex)/2
		cropV = (view_size.y-sizey)/2
		for t = startFrame to endFrame do
		(
			sliderTime = t
			dib = gw.getViewportDib()
			outputName = previewDir + fileName + (t as string) + ".tga"
			anim_bmp = bitmap view_size.x view_size.y
			cropped_bmp = bitmap sizex sizey filename:outputName
			copy dib anim_bmp
			pasteBitmap anim_bmp cropped_bmp (box2 cropH cropV (view_size.x-cropH) (view_size.y-cropV) ) [0,0]
			save cropped_bmp
			close anim_bmp
			close cropped_bmp
		)
		gc()
	)

	fn resizeViewport sizeX sizeY = (
		viewSize = getViewSize()
			xRatio = sizeX / viewSize.x
			yRatio = sizeY / viewSize.y
		if xRatio > yRatio then theRatio = xRatio
		else theRatio = yRatio
		convX = viewSize.x * theRatio
		convY = viewSize.y * theRatio
		gw.setPos 0 0 convX convY --setup viewport to desired size
		max views redraw --redraw the view
	)
	
	rollout movPreviewRollout ".mov Preview Maker" width:274 height:291
	(	
		
		editText edtPath "temp.seq.path:" pos:[6,13] width:215 height:22 text:(GetDir #preview)
		editText edtFilename "filename:" pos:[6,46] width:257 height:22 text:(getFilenameFile maxFileName)
		button btnPickPath "pick" pos:[227,15] width:39 height:19
		on btnPickPath pressed do
			edtPath.text = getSavePath caption "folder to save preview sequence"
		
		button btnAbout "About" pos:[221,84] width:42 height:36
		on btnAbout pressed do
				messagebox ("Creates a preview .mov (by default impossible in x64 max). You need to have Quicktime installed for this to work. You also need to have the companion 'qtSeq2mov.js' script in your\ndefault scripts folder (e.g. \"C:\Program Files\Autodesk\3ds Max 2009\Scripts\")\n\nVersion: "+version+"\n\nWritten by \nMayec Rancel \nhttp://www.mayec.eu")
		
		groupBox grpRange "Frame Range" pos:[6,75] width:200 height:46
		spinner spnStart "" pos:[15,96] width:75 height:16 type:#integer range:[animationrange.start,animationrange.end,animationrange.start]
		label lblTo "to" pos:[97,98] width:18 height:14
		spinner spnEnd "" pos:[112,96] width:75 height:16 type:#integer range:[animationrange.start,animationrange.end,animationrange.end]
		
		groupBox grpSize "Image Size" pos:[4,123] width:264 height:46
		spinner spnPercent "% of output" pos:[32,143] width:109 height:16 type:#integer range:[1,200,100]
		label lblRes "Resolution:" pos:[159,132] width:57 height:19
		editText edtResolution pos:[160,148] width:100 height:18 readOnly:true text:( ((finalWidth as integer) as string) + " x " + ((finalHeight as integer) as string) )
			on spnPercent changed newPercent do (
			edtResolution.text = ((finalWidth*newPercent/100 as integer) as string) + " x " + ((finalHeight*newPercent/100 as integer) as string)
		)
		
		checkbox chkDelete "Delete .tga sequence after .mov creation?" pos:[16,175] width:223 height:18 checked:true
		
		checkbox chkSound "Sound file:" pos:[17,209] width:73 height:18
		editText edtSoundFile "" pos:[88,207] width:138 height:22
		button btnPickSound "pick" pos:[230,209] width:39 height:19
		on btnPickSound pressed do
			edtSoundFile.text = getOpenFileName caption "pick sound file"
		
		button btnCreate "Create Preview!" pos:[20,247] width:105 height:31
		on btnCreate pressed do (
			
			previewPath = edtPath.text + "\\"
			if not existDir edtPath.text then
				makeDir edtPath.text all:true
			fileName = edtFilename.text
			rangeStart =spnStart.value
			rangeEnd = spnEnd.value
			sizex = finalWidth * spnPercent.value/100
			sizey = finalHeight * spnPercent.value/100
			origLayout = viewport.getLayout()
			
			-- store actual viewport settings
			wasMaximized = false
			wasFramed = false
			
			-- prepare viewport
			if viewport.numviews != 1 then (
				max tool maximize
				wasMaximized = true
			)
			if not displaySafeFrames then (
				displaySafeFrames = true
				wasFramed = true
			)
			resizeViewport sizex sizey
			
			-- Make image sequence preview
			mkPreviewSeq previewPath fileName sizex sizey rangeStart rangeEnd
			
			-- restore viewport
			if wasMaximized then
				max tool maximize
			if wasFramed then
				displaySafeFrames = false
			
			scrPath = GetDir #scripts
			inputFile = (previewPath + fileName + ((animationrange.start.frame as integer) as string) + ".tga")
			-- execute the seq2mov converter script
			print ("Executing external conversion to .MOV")
			if chkSound.checked then
				theCommand = "cscript.exe qtSeq2mov.js " + inputFile + " " + edtSoundFile.text
			else
				theCommand = "cscript.exe qtSeq2mov.js " + inputFile
			DOSCommand ("cd "+scrPath + " & " + theCommand) 
			-- if the "delete sequence" option was checked, do so
			if chkDelete.checked then
				for i = rangeStart to rangeEnd as integer do
					deleteFile (previewPath + fileName + (i as string) + ".tga")
			destroyDialog movPreviewRollout

		)
		button btnCancel "Cancel" pos:[157,247] width:105 height:31
		on btnCancel pressed do
			destroyDialog movPreviewRollout
		
		on movPreviewRollout open do (
			if (WAVsound.filename != "") then
			(
				chkSound.checked = true
				edtSoundFile.text = WAVsound.filename
			)
		)
		
		on movPreviewRollout close do
			gc()
		
	)

	createDialog movPreviewRollout
	
)