macroScript BakeAnim
category:"MayecTools"
buttontext:"BakeAnim"
tooltip:"Bake Animation"

(
/*************************************************************************************
Bake Animation
	
Author:Mayec Rancel
http://www.mayec.eu

Script Version:	1.1
	
Tested for Max Versions: 	max2009 x64.

Purpose:		Applies, through keyframing, the transform animations of source object to target object

created: 2009-02-07
last update: 2009-07-30
	
Known Bugs:

To Do:
	- Keep initial relative transform
*************************************************************************************/
	
	rollout baker "Animation Bake"
	(
		spinner anim_start "animation start" type:#integer range:[0,10000,animationRange.start] 
		spinner anim_end "animation end" type:#integer range:[0,10000,animationRange.end] 
		spinner step_size "step size" type:#integer range:[1,10,1]
		label lab_source "select source object:" align:#center
		pickbutton ssource "select source_obj" width:100
		label lab_target "select target object:" align:#center
		pickbutton starget "select target_obj" width:100
		checkbox poscheck "position"
		checkbox rotcheck "rotation"
		checkbox sclcheck "scale"
		button bake_anim "Bake Animation!"
		button aboutThis "About"
		on aboutThis pressed do
			messagebox "Bakes source object's animation to target object.\nv1.1\nWritten by Mayec Rancel\nhttp://www.mayecrancel.com"
		
		-- Initialize global variables
		global source = undefined
		global target = undefined

		-- selects source object that holds the animation
		on ssource picked obj do
		(
			ssource.text = obj.name
			global source = obj;
		)

		-- selects target object that animation will be baked to
		on starget picked obj do
		(
			starget.text = obj.name
			global target = obj;
		)

		-- bakes animation from source object to target object.
		on bake_anim pressed do
		(
			-- check if both source and target objects have been set
			if (target != undefined and source != undefined) then (
				-- check if at least one of the three channels is checked
				if (rotcheck.checked or poscheck.checked or sclcheck.checked) then
				(
					sliderTime = anim_start.value
					animate on (
						for i in anim_start.value to anim_end.value by step_size.value do
						(
							if rotcheck.checked do
								in coordsys (transmatrix target.transform.pos) target.rotation = inverse source.transform.rotation
							if poscheck.checked do
								in coordsys world target.position = source.transform.position
							if sclcheck.checked do
								target.scale = source.scale
							slidertime += step_size.value
						)
					)
				)
				-- message error for no channel checked
				else messagebox "You have to pick at least one channel (position, rotation or scale)"
			)
			-- message error for no source/target objects selected
			else messagebox "You have to set both a SOURCE and a TARGET object"
		)
	)

	createDialog baker width:200
	
)
